﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Asteroid
  {
  class FramePacket
    {
    private string m_strBuf = string.Empty;
    /// <summary>
    /// Gets the server information.
    /// </summary>
    /// <value>The server information.</value>
    /// ****************************************************************************************************
    /// * Datum: 07.05.2008 19:01
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung:  
    /// ****************************************************************************************************
    public string ServerInformation
      {
      get
        {
        return m_strBuf;
        }
      }


    private byte[] m_arrPacket = new byte[1026];
    /// <summary>
    /// Sets the recived packet.
    /// </summary>
    /// <value>The recived packet.</value>
    /// ****************************************************************************************************
    /// * Datum: 15.04.2008 23:16
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung:  
    /// ****************************************************************************************************
    public byte[] RecivedPacket
      {
      set
        {
        try
          {
          int j = 0;
          m_arrPacket = value;

          for (int i = 0; i < 1024; i += 2)
            {
            m_arrReturn[j] = (ushort)(m_arrPacket[i + 1] << 8);
            m_arrReturn[j++] += (ushort)((m_arrPacket[i]));
            }
          }
        catch
          {
          m_strBuf = string.Empty;

          foreach (byte b in m_arrPacket)
            {
            m_strBuf += (char)b;
            }
          }
        }
      }

    private ushort[] m_arrReturn = new ushort[512];
    /// <summary>
    /// Gets the arr vector ram.
    /// </summary>
    /// <value>The arr vector ram.</value>
    /// ****************************************************************************************************
    /// * Datum: 14.04.2008 20:15
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung:  
    /// ****************************************************************************************************
    public ushort[] arrVectorRam
      {
      get
        {
        return m_arrReturn;
        }
      }

    /// <summary>
    /// Gets the byte vector ram.
    /// </summary>
    /// <value>The byte vector ram.</value>
    /// ****************************************************************************************************
    /// * Datum: 16.04.2008 18:52
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung:  
    /// ****************************************************************************************************
    public byte[] ByteVectorRam
      {
      get
        {
        return m_arrPacket;
        }
      }

    /// <summary>
    /// Gets the frameno.
    /// </summary>
    /// <value>The frameno.</value>
    /// ****************************************************************************************************
    /// * Datum: 14.04.2008 21:27
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung:  
    /// ****************************************************************************************************
    public byte Frameno
      {
      get
        {
        try
          {
          return m_arrPacket[1024];
          }
        catch
          {
          return m_arrPacket[m_arrPacket.Length - 1];
          }
        }
      }

    /// <summary>
    /// Gets the ping.
    /// </summary>
    /// <value>The ping.</value>
    /// ****************************************************************************************************
    /// * Datum: 14.04.2008 21:27
    /// * Computer: ATHLON3500VISTA
    /// * Benutzer: thomas
    /// *
    /// * Beschreibung:  
    /// ****************************************************************************************************
    public byte Ping
      {
      get
        {
        try
          {
          return m_arrPacket[1025];
          }
        catch
          {
          return m_arrPacket[m_arrPacket.Length - 1];
          }
        }

      }
    }
  }
